//IE8 or below doesn't support trim, below is the workaround
if(typeof String.prototype.trim !== 'function') {
  String.prototype.trim = function() {
    return this.replace(/^\s+|\s+$/g, ''); 
  }
}

//submit payment data to PayPal and charge it
function mf_submit_payment(payment_nonce){

    var mf_ship_same_as_billing = 1;
    if($("#mf_same_shipping_address").prop("checked") == true){
    	mf_ship_same_as_billing = 1;
    }else{
    	mf_ship_same_as_billing = 0;
    }

	//billing address
	var mf_address_line1 = '';
	var mf_address_city = '';
	var mf_address_state = '';
	var mf_address_zip = '';
	var mf_address_country = '';

	//shipping address
	var mf_ship_address_line1 = '';
	var mf_ship_address_city = '';
	var mf_ship_address_state = '';
	var mf_ship_address_zip = '';
	var mf_ship_address_country = '';

	//collect billing address
	if($("#li_billing_address").length > 0){
		mf_address_line1 = $("#billing_street").val().trim();
		mf_address_city = $("#billing_city").val().trim();
		mf_address_state = $("#billing_state").val().trim();
		mf_address_zip = $("#billing_zipcode").val().trim();
		mf_address_country = $("#billing_country").val().trim();
	}

	//collect shipping address
	if($("#li_shipping_address").length > 0){
		mf_ship_address_line1 = $("#shipping_street").val().trim();
		mf_ship_address_city = $("#shipping_city").val().trim();
		mf_ship_address_state = $("#shipping_state").val().trim();
		mf_ship_address_zip = $("#shipping_zipcode").val().trim();
		mf_ship_address_country = $("#shipping_country").val().trim();
	}


    //collect all payment data
    var payment_data = {
    					nonce: payment_nonce,
    					
						first_name: $("#cc_first_name").val().trim(), 
    					last_name: $("#cc_last_name").val().trim(),
						
    					billing_street: mf_address_line1,
						billing_city: mf_address_city,
						billing_state: mf_address_state,
						billing_zipcode: mf_address_zip,
						billing_country: mf_address_country,

						same_shipping_address: mf_ship_same_as_billing,

						shipping_street: mf_ship_address_line1,
						shipping_city: mf_ship_address_city,
						shipping_state: mf_ship_address_state,
						shipping_zipcode: mf_ship_address_zip,
						shipping_country: mf_ship_address_country
    				};
    
    //do the ajax call to charge the card and send the payment data
	$.ajax({
			type: "POST",
			async: true,
			url: $("#main_body").data("machformpath") + "payment_submit_braintree.php",
			data: {
					form_id: $("#form_id").val(),
					mfsid: $("#mfsid").val(),
					record_id: $("#main_body").data("recordid"),
					payment_properties: payment_data
				  },
				  cache: false,
				  global: false,
				  dataType: "json",
				  error: function(xhr,text_status,e){
						//display the error on credit card field
						$("#error_message").show();
						$("#li_credit_card").addClass("error");
							
						$("#credit_card_error_message").html("Unknown Error. Please contact tech support.").show();

						//enable submit button again
						$("#btn_submit_payment").prop("disabled",false);
						$("#btn_submit_payment").val($("#btn_submit_payment").data('originallabel'));
						$("#mf_payment_loader_img").hide();

						if($("html").hasClass("embed")){
							$.postMessage({mf_iframe_height: $('body').outerHeight(true)}, '*', parent );
						}

						alert('There was a problem with your submission. Please check highlighted fields. \nError message: ' + xhr.responseText);
				  },
				  success: function(response_data){							   
						if(response_data.status == 'ok'){
							$("#form_payment_redirect").trigger("submit");
						}else{
							//display the error on credit card field
							$("#error_message").show();
							$("#li_credit_card").addClass("error");
								
							$("#credit_card_error_message").html(response_data.message).show();

							//enable submit button again
							$("#btn_submit_payment").prop("disabled",false);
							$("#btn_submit_payment").val($("#btn_submit_payment").data('originallabel'));
							$("#mf_payment_loader_img").hide();

							if($("html").hasClass("embed")){
								$.postMessage({mf_iframe_height: $('body').outerHeight(true)}, '*', parent );
							}

							alert('There was a problem with your submission. Please check highlighted fields.');
						}   
				  }
	});
	
}


//reset all error messages on the form
function mf_clear_errors(){
	$("#error_message").hide();
	$("li.error").removeClass('error');
	$("#credit_card_error_message").html('');
	$("#shipping_error_message").html('');
	$("#billing_error_message").html('');
}

//validate all required fields and format
function mf_validate_fields(){
	var validation_status = true;

	//validate billing address, if exist
	if($("#li_billing_address").length > 0){
		if($("#billing_street").val().trim().length == 0 || $("#billing_city").val().trim().length == 0 || $("#billing_state").val().trim().length == 0 || $("#billing_zipcode").val().trim().length == 0 || $("#billing_country").val().trim().length == 0){
			$("#error_message").show();
			$("#li_billing_address").addClass("error");
			
			$("#billing_error_message").html("The field is required. Please enter a complete billing address.").show();

			validation_status = false;
		}
	}

	//validate shipping address, if exist
	if($("#li_shipping_address").length > 0){
		if($("#mf_same_shipping_address").prop("checked") == false){
			if($("#shipping_street").val().trim().length == 0 || $("#shipping_city").val().trim().length == 0 || $("#shipping_state").val().trim().length == 0 || $("#shipping_zipcode").val().trim().length == 0 || $("#shipping_country").val().trim().length == 0){
				$("#error_message").show();
				$("#li_shipping_address").addClass("error");
				
				$("#shipping_error_message").html("The field is required. Please enter a complete shipping address.").show();

				validation_status = false;
			}
		}
	}

	return validation_status;
}

$(function(){
	
	braintree.client.create({
		authorization: mf_braintree_client_token
	}).then(function (clientInstance) {
		var options = {
		  client: clientInstance,
		  styles: {
			'input': {
				'font-size': '13px',
				'font-family': 'Arial, Verdana, sans-serif',
				'color': '#3A3A3A',
				'line-height': '13px'
			},
			'select': {
				'font-size': '13px',
				'font-family': 'Arial, Verdana, sans-serif',
				'color': '#3A3A3A',
				'line-height': '13px'
			}
		  },
		  fields: {
			number: {
				selector: '#cc_number',
				placeholder: ''
			},
			cvv: {
				selector: '#cc_cvv',
				placeholder: ''
			},
			expirationMonth: {
				container: '#cc_expiry_month',
				placeholder: $(".HOSTED_FIELDS_EXPIRY_MONTH_LABEL").html(),
				select: {
				  options: [
					'01 - January',
					'02 - February',
					'03 - March',
					'04 - April',
					'05 - May',
					'06 - June',
					'07 - July',
					'08 - August',
					'09 - September',
					'10 - October',
					'11 - November',
					'12 - December'
				  ]
				}
			  },
			expirationYear: {
				container: '#cc_expiry_year',
				placeholder: $(".HOSTED_FIELDS_EXPIRY_YEAR_LABEL").html(),
				select: true
			}
		  }
		};
	  
		return braintree.hostedFields.create(options);
	}).then(function (hostedFieldsInstance) {
		
		//use the Hosted Fields instance here to tokenize a card
		$('form.appnitro').on("submit",function(){
				var fields_validated = false;

				//disable submit button
				$("#btn_submit_payment").val("Processing. Please wait...");
				$("#btn_submit_payment").prop("disabled",true);
				$("#mf_payment_loader_img").show();

				mf_clear_errors();
				fields_validated = mf_validate_fields();

				if(fields_validated === true){
					//tokenize the card and send it to Braintree upon sucessfull event
					hostedFieldsInstance.tokenize(function (tokenizeErr, payload) {
						if (tokenizeErr) {
							console.log(tokenizeErr);

							//enable submit button again
							$("#btn_submit_payment").prop("disabled",false);
							$("#btn_submit_payment").val($("#btn_submit_payment").data('originallabel'));
							$("#mf_payment_loader_img").hide();

							if($("html").hasClass("embed")){
								$.postMessage({mf_iframe_height: $('body').outerHeight(true)}, '*', parent );
							}
							
							//display the error on credit card field
							$("#error_message").show();
							$("#li_credit_card").addClass("error");
							
							if($("." + tokenizeErr.code).length > 0){
								var braintree_error_message = $("." + tokenizeErr.code).html();
							}else{
								var braintree_error_message = $(".HOSTED_FIELDS_UNKNOWN").html();
							}
							
							$("#credit_card_error_message").html(braintree_error_message).show();
							
						}else{
							//send request to Braintree
							mf_submit_payment(payload.nonce);
						}
					});

						
				}else{
					//enable submit button again
					$("#btn_submit_payment").prop("disabled",false);
					$("#btn_submit_payment").val($("#btn_submit_payment").data('originallabel'));
					$("#mf_payment_loader_img").hide();

					if($("html").hasClass("embed")){
						$.postMessage({mf_iframe_height: $('body').outerHeight(true)}, '*', parent );
					}
					
					alert('There was a problem with your submission. Please check highlighted fields.');
				}

				//always return false, to override submit event
				return false;
		});
	}).catch(function (err) {
		// Handle error in component creation
		console.log(err);
	});

	//attach event handler to shipping address checkbox
	$('#mf_same_shipping_address').on('change', function() {
		if($(this).prop("checked") == true){
			$(".shipping_address_detail").hide();
		}else{
			$(".shipping_address_detail").show();
		}

		if($("html").hasClass("embed")){
			$.postMessage({mf_iframe_height: $('body').outerHeight(true)}, '*', parent );
		}
		
	});

});
